<?php
/**
* Plugin Name: rankmath bulk noindex and nofollow
* Plugin URI: https://keentalking.com/rankmath-bulk-set-noindex/
* Description: bulk edit noindex and nofollow
* Version: 0.1
* Author: keen
* Author URI: https://keentalking.com/
**/
add_filter( 'manage_posts_columns', 'keen_index_follow_column' );
function keen_index_follow_column( $column_array ) {
    $column_array[ 'index_follow' ] = 'Index and Follow';
    return $column_array;
}

add_action( 'manage_posts_custom_column', 'keen_value_columns', 10, 2 );
function keen_value_columns( $column_name, $post_id ) {
    switch( $column_name ) {
        case 'index_follow': {
            $index_follows = get_post_meta( $post_id, 'rank_math_robots', true );
            if($index_follows){
                foreach ($index_follows as $index_follow){
                    echo $index_follow.'<br/>';
                }
            }else{
                echo 'index<br>follow';
            }
            break;
        }
    }
}

add_action( 'bulk_edit_custom_box',  'keen_quick_edit_fields', 10, 2 );
function keen_quick_edit_fields( $column_name, $post_type ) {
    switch( $column_name ) {
        case 'index_follow': {
            ?>  
                <fieldset class="inline-edit-col-left">
                    <div class="inline-edit-col">
                        <span class="title inline-edit-categories-label">Rank math robots</span>
                        <ul style="height: 14em;border: 1px solid #ddd;margin: 0 0 5px;padding: .2em 5px;overflow-y: scroll;">
                            <li><label><input type="radio" id="index" value="0" name="index"/><span class="title">index</span></label></li>
                            <li><label><input type="radio" id="noindex" value="1" name="index"/><span class="title">noindex</span></label></li>
                        </ul>
                    </div>
                <?php
            break;
        }
    }
}
add_action( 'save_post', 'keen_bulk_edit_save' );
function keen_bulk_edit_save( $post_id ){
    if ( ! wp_verify_nonce( $_REQUEST[ '_wpnonce' ], 'bulk-posts' ) ) {
        return;
    }
    $index = ! empty( $_REQUEST[ 'index' ] ) ? absint( $_REQUEST[ 'index' ] ) : 0;
    if($index==1){
        $robot_array = array('noindex','nofollow');
        update_post_meta( $post_id, 'rank_math_robots', $robot_array );
    }elseif($index==0){
        //$robot_array = array('index');
        update_post_meta( $post_id, 'rank_math_robots', '' );
    }
}